---
category: api-reference
---

# CKEditor 5 text part language feature

[![npm version](https://badge.fury.io/js/%40ckeditor%2Fckeditor5-language.svg)](https://www.npmjs.com/package/@ckeditor/ckeditor5-language)

This package implements text part language support for CKEditor 5 that allows you to define the language for each passage of content written in multiple languages. It helps satisfy the [WCAG Success Criterion 3.1.2 Language of Parts](https://www.w3.org/TR/UNDERSTANDING-WCAG20/meaning-other-lang-id.html).

## Demo

Check out the {@link features/language#demo demo in the text part language feature guide}.

## Documentation

See the {@link features/language text part language feature guide}.

You can also check out the following plugins:

* {@link module:language/textpartlanguage~TextPartLanguage}

## Installation

```
npm install --save @ckeditor/ckeditor5-language
```

## Contribute

The source code of this package is available on GitHub in [https://github.com/ckeditor/ckeditor5/tree/master/packages/ckeditor5-language](https://github.com/ckeditor/ckeditor5/tree/master/packages/ckeditor5-language).

## External links

* [`@ckeditor/ckeditor5-language` on npm](https://www.npmjs.com/package/@ckeditor/ckeditor5-language)
* [`ckeditor/ckeditor5-language` on GitHub](https://github.com/ckeditor/ckeditor5/tree/master/packages/ckeditor5-language)
* [Issue tracker](https://github.com/ckeditor/ckeditor5/issues)
* [Changelog](https://github.com/ckeditor/ckeditor5/blob/master/CHANGELOG.md)
