---
# Scope:
# * Explain browser compatibility of CKEditor 5.
# * Document known compatibility issues and missing features.
# * Discuss support for mobile environments.

category: support
order: 20
---

# Browser compatibility

## Desktop environment

CKEditor 5 is currently supported in the following desktop browsers:

* Full support:
	* Chrome (latest stable release).
	* Firefox (latest stable release).
	* Safari (latest stable release).
	* Opera (latest stable release).
	* Electron (latest stable release).
	* Edge (latest stable release).

## Mobile environment

CKEditor 5 is currently supported in the following mobile environments:

* Android (all vendor-supported versions)
* iOS (all vendor-supported versions)
* Android WebView
* iOS WebView (UIWebView and WKWebView)

## Quality assurance

To ensure the highest quality, we maintain a complete test suite with a stable 100% of code coverage for each of the packages. As of May 2022, this means over 21,000 tests and the number is growing &ndash; you can check the [Why CKEditor?](https://ckeditor.com/why-ckeditor/) page if you want more statistics about CKEditor!

Such an extensive test suite requires a proper continuous integration service. We use [Travis CI](https://travis-ci.com/) as a build platform. This service ensures seamless and fast developer experience and allow us to focus on the job.
