---
category: api-reference
---

# API documentation

<info-box>
	Use the <span class="navigation-hint_desktop">**navigation tree on the left**</span><span class="navigation-hint_mobile">**main menu button in the upper-left corner**</span> to navigate through CKEditor API.
</info-box>

## Popular API pages

* {@link module:core/editor/editorconfig~EditorConfig Configuration Reference} &ndash; CKEditor configuration settings explained.
* {@link module:editor-classic/classiceditor~ClassicEditor `ClassicEditor`} &ndash; The entry point for the Classic editor integration.
* {@link module:editor-inline/inlineeditor~InlineEditor `InlineEditor`} &ndash; The entry point for the Inline editor integration.
* {@link module:editor-balloon/ballooneditor~BalloonEditor `BalloonEditor`} &ndash; The entry point for the Balloon editor integration.

## Documentation

* {@link framework/index CKEditor 5 Framework} &ndash; Learn how to develop with CKEditor 5 Framework, customize it and create plugins.
* {@link installation/index Installing CKEditor 5} &ndash; Learn how to install, integrate and configure CKEditor 5 builds. More complex aspects, like creating custom builds, are explained here, too.
* {@link features/index Features} &ndash; Learn about some of the features included in CKEditor 5 builds.

## Contribute

CKEditor is an Open Source project and your contribution is most welcome. Feel free to {@link support/reporting-issues report bugs} or improve the code on [GitHub](https://github.com/ckeditor/ckeditor5). Since CKEditor is localized, you can also help [to translate it](https://www.transifex.com/ckeditor/ckeditor5/). You do not need to be a programmer to contribute to the project!
